/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.test;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.modernui.animation.Applier;
import icyllis.modernui.core.mixin.AccessFoodData;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.math.TextAlign;
import icyllis.modernui.graphics.textmc.ModernFontRenderer;
import icyllis.modernui.math.Matrix4;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.lwjgl.opengl.GL11;

public class TestHUD {
    public static boolean sDing;
    public static boolean sFirstScreenOpened;
    public static boolean sBars;
    public static final TestHUD sInstance;
    private final float[] mProj = new float[16];
    private final icyllis.modernui.animation.Animation mBarAlphaAnim = new icyllis.modernui.animation.Animation(5000).applyTo(new Applier(0.5f, 0.25f, () -> Float.valueOf(this.mBarAlpha), f -> {
        this.mBarAlpha = f.floatValue();
    }).setInterpolator(p -> Math.max((p - 0.8f) * 5.0f, 0.0f)));
    private float mBarAlpha = 0.25f;
    private float mLastHealth;
    private int mLastHunger;
    private int mLastAir;
    private final List<ITextProperties> mTempTexts = new ArrayList<ITextProperties>();
    public static boolean sTooltip;
    public static int sTooltipR;
    public static int sTooltipG;
    public static int sTooltipB;
    private static final int TOOLTIP_SPACE = 12;
    private static final int H_BORDER = 5;
    private static final int V_BORDER = 4;
    private static final int LINE_HEIGHT = 10;
    private static final int TITLE_GAP = 2;

    public void drawBars(@Nonnull Canvas canvas) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableDepthTest();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        Minecraft minecraft = Minecraft.func_71410_x();
        MainWindow windowB3D = minecraft.func_228018_at_();
        float aspectRatio = (float)windowB3D.func_198109_k() / (float)windowB3D.func_198091_l();
        Matrix4.makePerspective(1.5707964f, aspectRatio, 1.0f, 100.0f).put(this.mProj);
        GL11.glMultMatrixf((float[])this.mProj);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)(-1.58f * aspectRatio), (float)-1.0f, (float)-1.8f);
        GL11.glScalef((float)0.011111111f, (float)-0.011111111f, (float)0.011111111f);
        GL11.glRotatef((float)18.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        PlayerEntity player = (PlayerEntity)minecraft.func_175606_aa();
        Objects.requireNonNull(player);
        float partialTicks = Animation.getPartialTickTime();
        float f = player.field_70140_Q - player.field_70141_P;
        float f1 = -(player.field_70140_Q + f * partialTicks);
        float f2 = MathHelper.func_219799_g((float)partialTicks, (float)player.field_71107_bF, (float)player.field_71109_bG);
        GL11.glTranslatef((float)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 0.5f), (float)Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) * f2), (float)0.0f);
        GL11.glRotatef((float)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        FoodStats foodData = player.func_71024_bL();
        float health = player.func_110143_aJ();
        if (health != this.mLastHealth) {
            this.mLastHealth = health;
            this.mBarAlphaAnim.startFull();
        }
        float right = Math.min(health * 140.0f / player.func_110138_aP(), 140.0f);
        Paint paint = Paint.take();
        paint.reset();
        paint.setStrokeWidth(1.5f);
        paint.setAlpha((int)(this.mBarAlpha * 255.0f));
        paint.setRGB(255, 19, 19);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawRoundRect(0.0f, 25.0f, right, 37.0f, 6.0f, paint);
        paint.setRGB(255, 255, 255);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawRoundRect(0.0f, 25.0f, 140.0f, 37.0f, 6.0f, paint);
        int air = player.func_70086_ai();
        if (air != this.mLastAir) {
            this.mLastAir = air;
            this.mBarAlphaAnim.startFull();
        }
        right = (float)air * 140.0f / (float)player.func_205010_bg();
        paint.setRGB(86, 184, 255);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawRoundRect(0.0f, 11.0f, right, 23.0f, 6.0f, paint);
        paint.setRGB(255, 255, 255);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawRoundRect(0.0f, 11.0f, 140.0f, 23.0f, 6.0f, paint);
        int foodLevel = foodData.func_75116_a();
        if (foodLevel != this.mLastHunger) {
            this.mLastHunger = foodLevel;
            this.mBarAlphaAnim.startFull();
        }
        right = foodLevel * 7;
        paint.setRGB(184, 132, 88);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawRoundRect(0.0f, -3.0f, right, 9.0f, 6.0f, paint);
        paint.setRGB(255, 255, 255);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawRoundRect(0.0f, -3.0f, 140.0f, 9.0f, 6.0f, paint);
        canvas.resetColor();
        canvas.setAlpha((int)(this.mBarAlpha * 255.0f * 2.0f));
        canvas.setTextAlign(TextAlign.CENTER);
        canvas.drawText(String.format("%.2f / %.2f", Float.valueOf(player.func_110143_aJ()), Float.valueOf(player.func_110138_aP())), 70.0f, 27.0f);
        canvas.drawText(String.format("%d / %d", player.func_70086_ai(), player.func_205010_bg()), 70.0f, 13.0f);
        canvas.drawText(String.format("%d / %.2f / %.2f", foodData.func_75116_a(), Float.valueOf(foodData.func_75115_e()), Float.valueOf(((AccessFoodData)foodData).getExhaustionLevel())), 70.0f, -1.0f);
        RenderSystem.enableDepthTest();
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        RenderSystem.enableTexture();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        minecraft.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
    }

    public void drawTooltip(Canvas canvas, @Nonnull List<? extends ITextProperties> texts, ModernFontRenderer font, ItemStack stack, MatrixStack matrix, int eventX, int eventY, float mouseX, float mouseY, float width, float height) {
        int n;
        float tooltipX = mouseX + 12.0f;
        float tooltipY = mouseY - 12.0f;
        int tooltipWidth = 0;
        int tooltipHeight = 8;
        for (ITextProperties iTextProperties : texts) {
            tooltipWidth = Math.max(tooltipWidth, font.func_238414_a_(iTextProperties));
        }
        boolean needWrap = false;
        if (tooltipX + (float)tooltipWidth + 5.0f > width && (tooltipX = mouseX - 12.0f - 5.0f - (float)tooltipWidth) < 5.0f) {
            tooltipWidth = (int)(mouseX > width / 2.0f ? mouseX - 12.0f - 10.0f : width - 12.0f - 5.0f - mouseX);
            needWrap = true;
        }
        boolean bl = true;
        if (needWrap) {
            int w = 0;
            List<ITextProperties> temp = this.mTempTexts;
            for (int i = 0; i < texts.size(); ++i) {
                List wrapped = font.func_238420_b_().func_238362_b_(texts.get(i), tooltipWidth, Style.field_240709_b_);
                if (i == 0) {
                    n = wrapped.size();
                }
                for (ITextProperties text : wrapped) {
                    w = Math.max(w, font.func_238414_a_(text));
                    temp.add(text);
                }
            }
            tooltipWidth = w;
            texts = temp;
            float f = tooltipX = mouseX > width / 2.0f ? mouseX - 12.0f - 5.0f - (float)tooltipWidth : mouseX + 12.0f;
        }
        if (texts.size() > 1) {
            tooltipHeight += (texts.size() - 1) * 10;
            if (texts.size() > n) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4.0f) {
            tooltipY = 4.0f;
        } else if (tooltipY + (float)tooltipHeight + 4.0f > height) {
            tooltipY = height - (float)tooltipHeight - 4.0f;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, 0.0, 400.0);
        Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
        if (eventX != (int)mouseX || eventY != (int)mouseY) {
            tooltipX += (float)(eventX - (int)mouseX);
            tooltipY += (float)(eventY - (int)mouseY);
        }
        int tooltipLeft = (int)tooltipX;
        int tooltipTop = (int)tooltipY;
        float partialX = tooltipX - (float)tooltipLeft;
        float partialY = tooltipY - (float)tooltipTop;
        GL11.glPushMatrix();
        RenderSystem.multMatrix((Matrix4f)mat);
        Paint paint = Paint.take();
        paint.reset();
        paint.setRGBA(0, 0, 0, 208);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawRoundRect(tooltipX - 5.0f, tooltipY - 4.0f, tooltipX + (float)tooltipWidth + 5.0f, tooltipY + (float)tooltipHeight + 4.0f, 3.0f, paint);
        paint.setRGBA(sTooltipR, sTooltipG, sTooltipB, 240);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(1.5f);
        canvas.drawRoundRect(tooltipX - 5.0f, tooltipY - 4.0f, tooltipX + (float)tooltipWidth + 5.0f, tooltipY + (float)tooltipHeight + 4.0f, 3.0f, paint);
        GL11.glPopMatrix();
        IRenderTypeBuffer.Impl buf = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        for (int i = 0; i < texts.size(); ++i) {
            ITextProperties text = texts.get(i);
            if (text != null) {
                font.drawText(text, tooltipX, tooltipY, -1, true, mat, (IRenderTypeBuffer)buf, false, 0, 0xF000F0);
            }
            if (i + 1 == n) {
                tooltipY += 2.0f;
            }
            tooltipY += 10.0f;
        }
        buf.func_228461_a_();
        matrix.func_227865_b_();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)partialX, (float)partialY, (float)0.0f);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, texts, matrix, tooltipLeft, tooltipTop, (FontRenderer)font, tooltipWidth, tooltipHeight));
        GL11.glPopMatrix();
        RenderSystem.enableDepthTest();
        this.mTempTexts.clear();
    }

    static {
        sInstance = new TestHUD();
        sTooltipR = 170;
        sTooltipG = 220;
        sTooltipB = 240;
    }
}

